capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Time Varying Models-5Sep2025\Time Varying Models"
set more off
set maxiter 3000

**** SET PERIOD ***
local perd "short"     // can be "long" or "short"

log using "Output/log/LSE-ADTT/anOpexReg24-LSE-ADTT-`perd'", replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Time-Varying Models
			LSE Models
Author:  Alice Giovani & Michael Cunningham
File:    anOpexReg24-LSE-ADTT.do
Initial Date:    19-Mar-2025
Revised Date:	 1-Sep-2025

--------------------------------------------------------------------------*/

* Period & dependent variable
if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2023

* 
scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data
use "Input/DNSPopex24", clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------
drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021
generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

* Regression log variables
gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

* TLG variables
gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

*Time Trend Variables

* center yr, generate(t)
forvalues i = 1/13 {
    gen dt`i' = d`i'* yr
}

* Labels
label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 
label variable dt1   "EVO-tt" 
label variable dt2   "AGD-tt" 
label variable dt3   "CIT-tt" 
label variable dt4   "END-tt" 
label variable dt5   "ENX-tt" 
label variable dt6   "ERG-tt"
label variable dt7   "ESS-tt" 
label variable dt8   "JEN-tt" 
label variable dt9   "PCR-tt" 
label variable dt10  "SAP-tt"
label variable dt11  "AND-tt" 
label variable dt12  "TND-tt" 
label variable dt13  "UED-tt"

* Documentation

putdocx begin
putdocx paragraph, style(Title)
putdocx text ("Time Varying LSE-ADTT-`perd' period" )

* Regression models
*---------------------- 
*================================
* 1. LSECD
*================================

xtpcse lvc ly1 ly2 ly3 lz1 yr jur2 jur3 d2-d13 dt1-dt13, c(a) het
estimates store LSECD

* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat

scalar k_lsecd = 33 
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSECD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 yr jur2 jur3 d2-d13 dt1-dt13

* OUTPUT ELASTICITIES	
predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD-ADTT Elasticities-`perd' period")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

*EFFICIENCY SCORES

predictnl eff1 = exp(min(0+_b[dt1]*yr, _b[d2]+_b[dt2]*yr, _b[d3]+_b[dt3]*yr, ///
	_b[d4]+_b[dt4]*yr, _b[d5]+_b[dt5]*yr, _b[d6]+_b[dt6]*yr, _b[d7]+_b[dt7]*yr, ///
	_b[d8]+_b[dt8]*yr,_b[d9]+_b[dt9]*yr, _b[d10]+_b[dt10]*yr, ///
	_b[d11]+_b[dt11]*yr, _b[d12]+_b[dt12]*yr, _b[d13]+_b[dt13]*yr) ///
	- (0+_b[dt1]*yr)), ci(eff1_lb  eff1_ub)
	 
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1
		
forvalues i = 2/13 {
  predictnl eff`i' = exp(min(0+_b[dt1]*yr, _b[d2]+_b[dt2]*yr, _b[d3]+_b[dt3]*yr, ///
	_b[d4]+_b[dt4]*yr, _b[d5]+_b[dt5]*yr, _b[d6]+_b[dt6]*yr, _b[d7]+_b[dt7]*yr, ///
	_b[d8]+_b[dt8]*yr, _b[d9]+_b[dt9]*yr, _b[d10]+_b[dt10]*yr, ///
	_b[d11]+_b[dt11]*yr, _b[d12]+_b[dt12]*yr, _b[d13]+_b[dt13]*yr) ///
	- (_b[d`i']+_b[dt`i']*yr)), ci(eff`i'_lb  eff`i'_ub)
   
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

* Decomposition

gen firstob = 0
replace firstob = 1 if eiid != eiid[_n-1]

*
forvalues k = 1/3 {
	gen swgt`k' = (((1 - elY)/elY)*ely`k' + ///
		((1 - elY[_n-1])/elY[_n-1])*ely`k'[_n-1])/2  if firstob == 0	
	gen ywgt`k' = (ely`k'/elY + ely`k'[_n-1]/elY[_n-1])/2  if firstob == 0
		
}		
gen sec   = swgt1*(ly1 - ly1[_n-1]) + swgt2*(ly2 - ly2[_n-1]) + ///
		    swgt3*(ly3 - ly3[_n-1])        if firstob == 0	
gen tc1   = - _b[yr] * (yr - yr[_n-1])     if firstob == 0
gen tc2   = min(0+_b[dt1]*t, _b[d2]+_b[dt2]*t, _b[d3]+_b[dt3]*t, ///
	_b[d4]+_b[dt4]*t, _b[d5]+_b[dt5]*t, _b[d6]+_b[dt6]*t, _b[d7]+_b[dt7]*t, ///
	_b[d8]+_b[dt8]*t, _b[d9]+_b[dt9]*t, _b[d10]+_b[dt10]*t, ///
	_b[d11]+_b[dt11]*t, _b[d12]+_b[dt12]*t, _b[d13]+_b[dt13]*t) - ///
	min(0+_b[dt1]*t[_n-1], _b[d2]+_b[dt2]*t[_n-1], _b[d3]+_b[dt3]*t[_n-1], ///
	_b[d4]+_b[dt4]*t[_n-1], _b[d5]+_b[dt5]*t[_n-1], _b[d6]+_b[dt6]*t[_n-1], ///
	_b[d7]+_b[dt7]*t[_n-1], _b[d8]+_b[dt8]*t[_n-1], _b[d9]+_b[dt9]*t[_n-1], ///
	_b[d10]+_b[dt10]*t[_n-1], _b[d11]+_b[dt11]*t[_n-1], _b[d12]+_b[dt12]*t[_n-1], ///
	_b[d13]+_b[dt13]*t[_n-1])  if firstob == 0
gen tc = tc1 - tc2             if firstob == 0

gen oefc  = - _b[lz1] * (lz1 - lz1[_n-1])  if firstob == 0
gen tec   = ln(eff/eff[_n-1])        	   if firstob == 0

gen opfpc = sec + tc + oefc + tec          if firstob == 0

gen yc    = ywgt1*(ly1 - ly1[_n-1]) + ywgt2*(ly2 - ly2[_n-1]) + ///
		    ywgt3*(ly3 - ly3[_n-1])        if firstob == 0
gen costc = yhat - yhat[_n-1]              if firstob == 0			
gen opfpc2 = yc  - costc                   if firstob == 0

export excel eiid year eff eff_lb eff_ub sec tc oefc tec opfpc opfpc2 yc costc using ///
	"Output/xlsx/LSE-ADTT/LSE-ADTT-Eff-`perd'.xlsx" if dnsp < 14, ///
    sheet("LSECD") firstrow(var) replace nolabel

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD-ADTT Efficiency Scores-`perd' period")
table (country) (var), stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect
table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect

*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/LSE-ADTT/LSECD-ADTT-Eff-`perd'.png", replace
putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSECD-ADTT Efficiency Scores (`perd' period)")	
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-ADTT/LSECD-ADTT-Eff-`perd'.png", ///
	width(8) height(5.6)

* Residuals plots

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT")) ///
    yscale(range(-1,1)) ///
    ylabel(-1(0.2)1, grid)		
	
graph export "Output/chart/LSE-ADTT/LSECD-ADTT-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-ADTT/LSECD-ADTT-Res-`perd'.png", ///
	width(8) height(5.6)	
	
	
estout  LSECD using "Output/xlsx/LSE-ADTT/LSECD-ADTT-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") style(tab) label ///
	title("LSECD-ADTT-`perd'") stats(N bic, fmt(3)) replace
	
drop eff eff_lb eff_ub ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 ///
	elY lw_Y up_Y yhat eh ///
	swgt1 swgt2 swgt3 ywgt1 ywgt2 ywgt3 opfpc sec tc oefc tec opfpc2 yc costc ///
	tc1 tc2

*================================
* 2. LSETLG
*================================
xtpcse lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3 ///
	d2-d13 dt1-dt13, c(a) het

estimates store LSETLG

* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat

scalar k_lsetlg = 39 
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsetlg))	
display "LSETLG Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3 ///
	   d2-d13 dt1-dt13

test ly11 ly12 ly13 ly22 ly23 ly33

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) 
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) 
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-ADTT Elasticities - `perd' period")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,100,0)	
replace mon2 = cond(ely2 < 0,100,0)	
replace mon3 = cond(ely3 < 0,100,0)
replace montot = 100 if mon1 == 100 | mon2 == 100 | mon3 == 100

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-ADTT Monotonicity Violations - `perd' period")
table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.1f)
putdocx collect

*EFFICIENCY SCORES

predictnl eff1 = exp(min(0+_b[dt1]*yr, _b[d2]+_b[dt2]*yr, _b[d3]+_b[dt3]*yr, ///
	_b[d4]+_b[dt4]*yr, _b[d5]+_b[dt5]*yr, _b[d6]+_b[dt6]*yr, _b[d7]+_b[dt7]*yr, ///
	_b[d8]+_b[dt8]*yr,_b[d9]+_b[dt9]*yr, _b[d10]+_b[dt10]*yr, ///
	_b[d11]+_b[dt11]*yr, _b[d12]+_b[dt12]*yr, _b[d13]+_b[dt13]*yr) ///
	- (0+_b[dt1]*yr)), ci(eff1_lb  eff1_ub)
	 
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1
		
forvalues i = 2/13 {
  predictnl eff`i' = exp(min(0+_b[dt1]*yr, _b[d2]+_b[dt2]*yr, _b[d3]+_b[dt3]*yr, ///
	_b[d4]+_b[dt4]*yr, _b[d5]+_b[dt5]*yr, _b[d6]+_b[dt6]*yr, _b[d7]+_b[dt7]*yr, ///
	_b[d8]+_b[dt8]*yr, _b[d9]+_b[dt9]*yr, _b[d10]+_b[dt10]*yr, ///
	_b[d11]+_b[dt11]*yr, _b[d12]+_b[dt12]*yr, _b[d13]+_b[dt13]*yr) ///
	- (_b[d`i']+_b[dt`i']*yr)), ci(eff`i'_lb  eff`i'_ub)
   
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

* Decomposition

*
forvalues k = 1/3 {
	gen swgt`k' = (((1 - elY)/elY)*ely`k' + ///
		((1 - elY[_n-1])/elY[_n-1])*ely`k'[_n-1])/2  if firstob == 0	
	gen ywgt`k' = (ely`k'/elY + ely`k'[_n-1]/elY[_n-1])/2  if firstob == 0
		
}		
gen sec   = swgt1*(ly1 - ly1[_n-1]) + swgt2*(ly2 - ly2[_n-1]) + ///
		    swgt3*(ly3 - ly3[_n-1])        if firstob == 0	
gen tc1   = - _b[yr] * (yr - yr[_n-1])     if firstob == 0
gen tc2   = min(0+_b[dt1]*t, _b[d2]+_b[dt2]*t, _b[d3]+_b[dt3]*t, ///
	_b[d4]+_b[dt4]*t, _b[d5]+_b[dt5]*t, _b[d6]+_b[dt6]*t, _b[d7]+_b[dt7]*t, ///
	_b[d8]+_b[dt8]*t, _b[d9]+_b[dt9]*t, _b[d10]+_b[dt10]*t, ///
	_b[d11]+_b[dt11]*t, _b[d12]+_b[dt12]*t, _b[d13]+_b[dt13]*t) - ///
	min(0+_b[dt1]*t[_n-1], _b[d2]+_b[dt2]*t[_n-1], _b[d3]+_b[dt3]*t[_n-1], ///
	_b[d4]+_b[dt4]*t[_n-1], _b[d5]+_b[dt5]*t[_n-1], _b[d6]+_b[dt6]*t[_n-1], ///
	_b[d7]+_b[dt7]*t[_n-1], _b[d8]+_b[dt8]*t[_n-1], _b[d9]+_b[dt9]*t[_n-1], ///
	_b[d10]+_b[dt10]*t[_n-1], _b[d11]+_b[dt11]*t[_n-1], _b[d12]+_b[dt12]*t[_n-1], ///
	_b[d13]+_b[dt13]*t[_n-1])  if firstob == 0
gen tc = tc1 - tc2             if firstob == 0

gen oefc  = - _b[lz1] * (lz1 - lz1[_n-1])  if firstob == 0
gen tec   = ln(eff/eff[_n-1])        	   if firstob == 0

gen opfpc = sec + tc + oefc + tec          if firstob == 0

gen yc    = ywgt1*(ly1 - ly1[_n-1]) + ywgt2*(ly2 - ly2[_n-1]) + ///
		    ywgt3*(ly3 - ly3[_n-1])        if firstob == 0
gen costc = yhat - yhat[_n-1]              if firstob == 0			
gen opfpc2 = yc  - costc                   if firstob == 0


export excel eiid year eff eff_lb eff_ub sec tc oefc tec opfpc opfpc2 yc costc using ///
	"Output/xlsx/LSE-ADTT/LSE-ADTT-Eff-`perd'.xlsx" if dnsp < 14, ///
    sheet("LSETLG", modify) firstrow(var) nolabel

putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("Time Varying LSETLG-ADTT Efficiency Scores-`perd'")
table (country) (var), stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect
table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub) nformat(%5.3f)
putdocx collect


export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	using Output/xlsx/LSE-ADTT/monotonicity-`perd'.xlsx, ///
	sheet("LSETLG", replace) firstrow(var) 	
	
	
*Charts	
twoway (line eff year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

graph export "Output/chart/LSE-ADTT/LSETLG-ADTT-Eff-`perd'.png", replace
putdocx pagebreak
putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG-ADTT Efficiency Scores (`perd' period)")	
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-ADTT/LSETLG-ADTT-Eff-`perd'.png", ///
	width(8) height(5.6)

* Residuals plots

scatter eh yhat if country == 1, mcolor(blue) ///
    || scatter eh yhat if country == 2, mcolor(red) ///
    || scatter eh yhat if country == 3, mcolor(green) ///
    yline(0) ///
    ytitle("Residuals") ///
    xtitle("Fitted Values") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT")) ///
    yscale(range(-1,1)) ///
    ylabel(-1(0.2)1, grid)	
	
graph export "Output/chart/LSE-ADTT/LSETLG-ADTT-Res-`perd'.png", ///
	replace
putdocx paragraph, halign(center)
putdocx image "Output/chart/LSE-ADTT/LSETLG-ADTT-Res-`perd'.png", ///
	width(8) height(5.6)		
	

estout  LSETLG using "Output/xlsx/LSE-ADTT/LSETLG-ADTT-Reg-`perd'.tsv", ///
	cells("b(fmt(4)) se(fmt(4)) t(fmt(4))") style(tab) label ///
	title("LSETLG-ADTT-`perd'") stats(N bic, fmt(3)) replace
	
putdocx save "Output/docx/LSE-ADTT/LSE-ADTT-`perd'", replace

**	

log close

